function [img]=readimg(imgFile,hdr)
%[img]=readimg(imgFile,hdr)
%Read an img file.
%Input:
% imgFile: filename of a img file
% hdr: a hdr struct
%Output:
% img: a matrix containing voxel intensities
%
%Example:
%[img]=readimg('x.img')
%[img]=readimg('x.img',hdr)
%
%20040318, jdlee
%

%check input paramters
if(nargin<1),
  error('no input filename');    
end

[path,name,ext] = fileparts(imgFile);
imgFile = fullfile(path,[name '.img']);
hdrFile = fullfile(path,[name '.hdr']);

if(nargin<2|isempty(hdr)),
  hdr = rawhdr2hdr(readrawhdr(hdrFile));  
end

fid = fopen(imgFile,'rb',hdr.byte_order);
img = fread(fid,hdr.datatype);
img = reshape(img,hdr.dim);
fclose(fid);

return